{$DeskAcc 70 -1 'Show Clipboard' }
{$LongGlobals+}

program ClipNDA;
{
  A public-domain NDA by David A. Lyons.
  Watch for Shareware from:
    DAL Systems
    P.O. Box 287
    North Liberty IA 52317
    
    [CompuServe 72177,3233]
    [GEnie mail   D.LYONS2]

  Version 1.1:  Fixed bug where MyID was not being set when
                it was used to start up the Font Manager.
}

uses
  QDIntf, GSIntf, MiscTools, FontMgr;

const
  ScrapTool = $16;
  FontTool  = $1B;
  QDAuxTool = $12;

var
  myWindOpen:   boolean;
  myWind:       NewWindowParamBlk;
  myWindPtr:    WindowPtr;
  OldCount:     integer;
  FMDirPage:    ptr;
  MyID:         integer;
  LoadedSM, StartedSM,
  LoadedFM, StartedFM,
  LoadedQX, StartedQX: boolean;
  
function ScrapAvail: boolean;
begin
  ScrapAvail := (ScrapStatus<>0) and (ToolErrorNum=0);
end;

function QXAvail: boolean;
begin
  QXAvail := (QDAuxStatus<>0) and (ToolErrorNum=0);
end;

function FMAvail: boolean;
begin
  FMAvail := (FMStatus<>0) and (ToolErrorNum=0);
end;

function OKtoDraw: boolean;
begin
  OKtoDraw := QXAvail and FMAvail;
end;

procedure DoInfo;
const
  NumL = 10;
var
  myStr: array[1..NumL] of String[50];
  i: integer;
  return: char;
begin
  if not ScrapAvail then exit;
  return := char(13);
  myStr[1] := 'Clipboard v1.1 by David A. Lyons';
  myStr[2] := '';
  myStr[3] := 'A Public Domain NDA from:';
  myStr[4] := '  DAL Systems';
  myStr[5] := '  P.O. Box 287';
  myStr[6] := '  North Liberty, IA 52317';
  myStr[7] := '';
  myStr[8] := '  [CompuServe  72177,3233]';
  myStr[9] := '  [GEnie mail    D.LYONS2]';
  myStr[10]:= '  [AppleLinkPE Dave Lyons]';
  ZeroScrap;
  for i := 1 to NumL do begin
    PutScrap(length(myStr[i]),0,@myStr[i][1]);
    PutScrap(1,0,@return);
  end;
end; { DoInfo }

procedure SetupTools;
var
  dummy: integer;
begin
  { prepare to use Scrap Manager }
  dummy := ScrapVersion;
  if (ToolErrorNum>0) and (ToolErrorNum<$10) then begin
    LoadOneTool(ScrapTool,$0100);
    if ToolErrorNum=0 then LoadedSM := true;
  end;
  if (ScrapStatus=0) and (ToolErrorNum=0) then begin
    ScrapStartup;
    if ToolErrorNum=0 then StartedSM := true;
  end;
  { prepare to use Font Manager }
  dummy := FMVersion;
  if (ToolErrorNum>0) and (ToolErrorNum<$10) then begin
    LoadOneTool(FontTool,$0100);
    if ToolErrorNum=0 then LoadedFM := true;
  end;
  dummy := FMStatus;
  if (dummy=0) and (ToolErrorNum=0) then begin
    FMDirPage := NewHandle($100,MyID+$100,$C015,nil)^;
    if ToolErrorNum=0 then begin
      FMStartup(MyID+$100,LoWord(FMDirPage));
      if ToolErrorNum=0 then StartedFM := true;
    end;
  end;
  { prepare to use QuickDraw Auxiliary }
  dummy := QDAuxVersion;
  if (ToolErrorNum>0) and (ToolErrorNum<$10) then begin
    LoadOneTool(QDAuxTool,$0100);
    if ToolErrorNum=0 then LoadedQX := true;
  end;
  if (QDAuxStatus=0) and (ToolErrorNum=0) then begin
    QDAuxStartup;
    if ToolErrorNum=0 then StartedQX := true;
  end;
end;

procedure FinishTools;
begin
  if StartedQX and (QDAuxStatus<>0) and (ToolErrorNum=0) then
    QDAuxShutDown;
  if LoadedQX then UnloadOneTool(QDAuxTool);
  if StartedFM and (FMStatus<>0) and (ToolErrorNum=0) then
    FMShutdown;
  if LoadedFM  then UnloadOneTool(FontTool);
  if StartedSM and (ScrapStatus<>0) and (ToolErrorNum=0) then
    ScrapShutdown;
  if LoadedSM then UnloadOneTool(ScrapTool);
  DisposeAll(MyID+$100);
end;

function DAOpen: WindowPtr;
begin
  SetupTools;
  if myWindOpen then  
    SelectWindow(myWindPtr)
  else begin
    fillchar(myWind,sizeof(NewWindowParamBlk),0);
    with myWind do begin
       param_length := sizeof(NewWindowParamBlk);
       wFrame       := $DDA0;
       wTitle       := @' Clipboard NDA ';
       SetRect(wPosition,30,30,300,128);
       wPlane       := -1;
       wStorage     := nil;
    end;
    myWindPtr := NewWindow(myWind);   { Open NDA }
    SetSysWindow(myWindPtr);          { Make a system window }
  end;
  DAOpen     := myWindPtr;          { Return pointer }
  myWindOpen := true;               { Set flag to true }
  OldCount   := -1;
  LoadScrap;
{  if ScrapAvail then if GetScrapSize(0)=0 then DoInfo; }
end;

procedure DAClose;
begin
   if myWindOpen then CloseWindow(myWindPtr);
   myWindOpen := false;
end;

procedure DrawContent;
const
   textscrap = 0;
   picscrap  = 1;
var
   currPort: GrafPtr;
   TextHand:   Handle;
   PicHand:    PicHandle;
   tLength, pLength: longint;
   r: rect;
begin
   if not ScrapAvail then exit;
   currPort := GetPort;
   SetPort(myWindPtr);
   PicHand   := PicHandle(GetScrapHandle(picscrap));
   TextHand  := GetScrapHandle(textscrap);
   pLength   := GetScrapSize(picscrap);
   if ToolErrorNum<>0 then pLength := 0;
   tLength    := GetScrapSize(textscrap);
   if ToolErrorNum<>0 then tLength := 0;
   SetRect(r,0,0,10000,10000);
   EraseRect(r);
   if OKtoDraw and (pLength<>0) then begin { draw picture }
     r := PicHand^^.PicFrame;
     OffsetRect(r,-r.left,-r.top);
     if odd(PicHand^^.PicFrame.left) then OffsetRect(r,1,0);
     OffsetRect(r,10,5);
     DrawPicture(PicHand,r);
   end else begin
     SetForeColor(0);
     SetBackColor(15);
     HLock(TextHand);
     SetRect(r,10,5,10000,10000);
     LETextBox2(TextHand^,tLength,r,0);
     HUnlock(TextHand);
   end; { draw text }
   SetPort(currPort);
end;

procedure DAAction(Code: Integer; Param: EventRecordPtr);
var
   what, modifiers:  Integer;
   key: char;
begin
   case Code of
      DAEvent:
       begin
          what := param^.what;
          case what of
            updateEvt: begin
              BeginUpdate(myWindPtr);
              DrawContent;
              EndUpdate(myWindPtr);
            end;
            KeyDown: begin
              key := char(LoWord(param^.message));
              modifiers := param^.modifiers;
              if bitand(AppleKey,modifiers)<>0 then begin
                if (Key='c') or (Key='C') or
                   (Key='x') or (Key='X') then DoInfo
                else
                  SysBeep;
              end
            end;
         end;
       end;
      DARun: if ScrapAvail then begin
               if OldCount<>GetScrapCount then
                 DrawContent;
               OldCount := GetScrapCount;
             end else begin
               MoveTo(10,20);
               DrawString('[Scrap Manager not available]');
             end;
      DACursor,   {  Do nothing for these }
      DAMenu, 
      DAUndo,
      DAClear:  Code := 1;
      DACopy, DACut:  begin
                        DoInfo;
                        Code := 1;
                      end;
      DAPaste:        Code := 1;
   end;
end; { of DAAction }

{ The first call will be a ShutDown call made by the ProDOS
  loader.  We just assume that globals are initialized to 0! }
procedure DAInit(Code: Integer);
begin
  MyID := MMStartUp;
  if code<>0 then begin { start up }
    LoadedSM := false;  StartedSM := false;
    LoadedFM := false;  StartedFM := false;
    LoadedQX := false;  StartedQX := false;
    myWindOpen := false;
  end else begin { shut down }
    if myWindOpen then DAClose;
    FinishTools;
  end;
end; { DAInit }

begin 
  { No main program with NDA's }
end.
